function WTModel
% Model wait time with different models
clc; home;
close all hidden
clear;
clear global;
delete('ModelAccuracy.xlsx'); % delete previous output file 
addpath('.\Data\');

% If true, will increase number of optimization iterations and test sets
global bFullEvaluation fRemove
bFullEvaluation = true;
% kTestMax - number of model train/test runs for crossvalidation 
if bFullEvaluation
    kTestMax = 6;
else
    kTestMax = 6;
end

% Include interactions in the dataset
% Note: will make model training much longer!
bInteractions = false;

% If positive, used as the fraction of outliers to remove
% If negative, not used at all
% You may want to remove the longest waits because
% they corresponds to abnormal patient processing
fRemove = -0.05;

% Study model accuracy
tic

for Modality = ['1', '2', '3', '4'] % for all facilities F1, F2, F3, F4, or use only the ones you need
    
    % Start next modality
    nOutput = 0;
    fprintf('\n\n Modality = %s\n', Modality);
    
    % Load and set modality data
    %Data = DataImport(Modality, 'E'); % To compltely relod from Excel, takes time
    Data = DataImport(Modality, 'N'); % To load from pre-parsed Matlab files, faster
    DataY = Data.Wait;
    DataX = Data;  DataX(:,'Wait') = []; 
    
    if bInteractions
        % Add interactions
        DataXI = AddInteractions(DataX, Modality);
        DataXI.DataAge = DataX.DataAge;
        DataX = DataXI;
    end
    
    % Initialize metric variables
    R2 = zeros(100,1);           MAE = zeros(100,1);            MSE = zeros(100,1);
    R2_std = zeros(100,1);       MAE_std = zeros(100,1);        MSE_std = zeros(100,1);
    trainR2 = zeros(100,1);      trainMAE = zeros(100,1);       trainMSE = zeros(100,1);
    U05 = zeros(100,1);          U10 = zeros(100,1);
    Facility = cell(100,1);      MLmodel = cell(100,1);
    
    % Iterate through different ML models
    % Make a list of models you want to try, see
    % numeric model indices in ComputeModel file
    for Model = [130, 100] %list of models to try, see nModel values in ComputeModel.m
        fprintf('\n   Model = %d       ', Model);
        tR2 = zeros(kTestMax,1);        tMAE = zeros(kTestMax,1);           tMSE = zeros(kTestMax,1);
        ttrainR2 = zeros(kTestMax,1);   ttrainMAE = zeros(kTestMax,1);      ttrainMSE = zeros(kTestMax,1);
        tU05 = zeros(kTestMax,1);       tU10 = zeros(kTestMax,1);
        
        % Compute model on kTestMax random train-test pairs
        for kTest = 1:kTestMax
            [ML, Err, bTrainOnce] = ComputeModel(DataX, DataY, Model);
            fprintf('\n     %s, %s, MAE=%.3f (%.3f), R2=%.3f (%.3f), kTest = %d       ', Modality, ML, Err.MAE, Err.train.MAE, max(0,1-Err.ER2), max(0,1-Err.train.ER2), kTest);
            tR2(kTest) = max(0,1-Err.ER2);              tMAE(kTest) = Err.MAE;                tMSE(kTest) = Err.MSE;
            ttrainR2(kTest) = max(0,1-Err.train.ER2);   ttrainMAE(kTest) = Err.train.MAE;     ttrainMSE(kTest) = Err.train.MSE;
            tU05(kTest) = Err.U05;                      tU10(kTest) = Err.U10;
            
            % Exit if need to train once only
            if bTrainOnce
                break;
            end
        end % kTest
        
        % Record output, averaging train-test results
        nOutput = nOutput+1;
        R2(nOutput) = round(median(tR2), 3);            MAE(nOutput) = round(median(tMAE), 3);          MSE(nOutput) = round(median(tMSE), 3);
        if Model>=600 && Model<699
            R2(nOutput) = round(max(tR2), 3);            MAE(nOutput) = round(min(tMAE), 3);          MSE(nOutput) = round(min(tMSE), 3);
        end
        R2_std(nOutput) = round(std(tR2), 3);           MAE_std(nOutput) = round(std(tMAE), 3);         MSE_std(nOutput) = round(std(tMSE), 3);
        %trainR2(nOutput) = round(mean(ttrainR2), 3);    trainMAE(nOutput) = round(mean(ttrainMAE), 3);  trainMSE(nOutput) = round(mean(ttrainMSE), 3);
        trainR2(nOutput) = round(median(ttrainR2), 3);  trainMAE(nOutput) = round(median(ttrainMAE), 3); trainMSE(nOutput) = round(median(ttrainMSE), 3);
        U05(nOutput) = round(mean(tU05), 3);            U10(nOutput) = round(mean(tU10), 3);
        MLmodel{nOutput} = ML;                          Facility{nOutput} = Modality;

    end % Model
        
    
    % Save this modality data into Excel table
    TableOfResults = table(Facility, MLmodel, R2, MAE, MSE, U05, U10, trainR2, trainMAE, trainMSE);
    writetable(TableOfResults(1:nOutput, :), 'ModelAccuracy.xlsx', 'Sheet', Facility{1});
    fclose('all');
    toc
    
end % Modality

toc

return








