function [Data] = DataImport(Set, Reload)
% To load facility data

% Load data 
tic
if Reload == 'E' % full Excel reload, takes time 
    if Set=='4'
        Data = readtable('WaitData.Published.xlsx', 'Sheet', 'F4'); %XR
        save('Data.F4.mat', 'Data');
    elseif Set=='3'
        Data = readtable('WaitData.Published.xlsx', 'Sheet', 'F3'); %CT
        save('Data.F3.mat', 'Data');
    elseif Set=='2'
        Data = readtable('WaitData.Published.xlsx', 'Sheet', 'F2'); %MR
        save('Data.F2.mat', 'Data');
    elseif Set=='1'
        Data = readtable('WaitData.Published.xlsx', 'Sheet', 'F1'); %US
        save('Data.F1.mat', 'Data');
    else
        % Do all four modalities
        Data = DataImport('1', 'E');
        Data = DataImport('2', 'E');
        Data = DataImport('3', 'E');
        Data = DataImport('4', 'E');
        return;
    end
else % load from preprocessed Matlab files, works much faster
    if Set=='1'
        load('Data.F1.mat', 'Data');
    elseif Set=='2'
        load('Data.F2.mat', 'Data');
    elseif Set=='3'
        load('Data.F3.mat', 'Data');
    elseif Set=='4'
        load('Data.F4.mat', 'Data');
    else
        load('Data.mat', 'Data');
    end
end
toc

% Remove rows with invalid/missing data
% Should not have any of them really
Miss = ismissing(Data,{'' '.' 'NA' 'NULL' NaN});
iMiss = sum(Miss,2);
Data(iMiss>0, :) = [];

% Remove 'X_' and other variables, so marked as excluded from modeling
remove_list = [];
VariableNames = Data.Properties.VariableNames;
for i = 1:width(Data)
    VName = VariableNames{i};
    % Features with 'x_' prefix are for information only, remove
    if startsWith(VName,'x_')...
            || startsWith(VName,'w_')...
            || startsWith(VName,'model_')
        remove_list = [remove_list i];
    % Features with 'x_' prefix are for data sorting only, remove
    elseif startsWith(VName,'BeginDTTM')...
            || startsWith(VName,'ArrivalDTTM')...
            || startsWith(VName,'ScheduledDTTM')
        remove_list = [remove_list i];
    else
        % Assuming all columns are numeric, convert to double
        if iscell(Data.(VariableNames{i}))
            Data.(VariableNames{i}) = cellfun(@str2num, Data.(VariableNames{i}));
        else
            Data.(VariableNames{i}) = double(Data.(VariableNames{i}));
        end
    end
end

% Remove extra variables now
Data(:, remove_list) = [];

return
