function DI = AddInteractions(D, Set)

% Load feature model
if Set=='X'
    Model = readtable('BestInteractionModels.xlsx', 'Sheet', 'XR');
elseif Set=='C'
    Model = readtable('BestInteractionModels.xlsx', 'Sheet', 'CT');
elseif Set=='M'
    Model = readtable('BestInteractionModels.xlsx', 'Sheet', 'MR');
else % Set=='U'
    Model = readtable('BestInteractionModels.xlsx', 'Sheet', 'US');
end

% Add intercept
D.Intercept = zeros(size(D,1),1);

% Build interactions
nFeatures = length(Model.Feature);
FeatureList = [];
FeatureValues = zeros(size(D,1),nFeatures);
for nF = 1:nFeatures
    % Get features
    fnames = split(Model.Feature(nF), ':');
    if length(fnames)>1
        FeatureList{nF} = [fnames{1} '_' fnames{2}];
        FeatureValues(:,nF) = table2array(D(:,fnames{1})).*table2array(D(:,fnames{2}));
    else
        FeatureList{nF} = [fnames{1}];
        FeatureValues(:,nF) = table2array(D(:,fnames{1}));
    end
end
    
DI = array2table(FeatureValues, 'VariableNames', FeatureList);

return